#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define BGM_FILE	"th135b_bgm_tmp.dat"
#define MAX_BGM		13

int bgmtable[MAX_BGM][3]={
	{0x0000002C, 0x001409FC, 0x00D8A58C},
	{0x00E80058, 0x00000000, 0x0039DD08},
	{0x0121DD8C, 0x00000000, 0x0039DE00},
	{0x015BBBB8, 0x00000000, 0x0039DE6C},
	{0x01959A50, 0x00000000, 0x0039DE34},
	{0x01CF78B0, 0x00000000, 0x0039DE30},
	{0x0209570C, 0x00000000, 0x0039DE28},
	{0x02433560, 0x00000000, 0x0039DE5C},
	{0x027D13E8, 0x00000000, 0x0039DDA4},
	{0x02B6F1B8, 0x00000000, 0x0039DDEC},

	{0x02F0CFD0, 0x00000000, 0x0039DDFC},
	{0x032AADF8, 0x000A59E4, 0x007B0658},
	{0x03B435E0, 0x001AF2B8, 0x00545E84}
};

char bgmfile[MAX_BGM][50]={
	"01 ґI.wav",
	"02 lC^얲.wav",
	"03 lC^J.wav",
	"04 lC^_ց_R.wav",
	"05 lC^@.wav",
	"06 lC^zs.wav",
	"07 lC^L_q.wav",
	"08 lC^͏ɂƂ.wav",
	"09 lC^Ön.wav",
	"10 lC^b}~]E.wav",

	"11 lC^`.wav",
	"12 Xg[h.wav",
	"13 {̈ʋLiVer1.20j.wav"
};

void makeheader(char *header,int datasize){
	int i;
	short s;
	memcpy(header,"RIFF",4);
	i = datasize + 36;
	memcpy(header+4,&i,4);
	memcpy(header+8,"WAVEfmt ",8);
	i = 16;
	memcpy(header+16,&i,4);
	s = 1;
	memcpy(header+20,&s,2);
	s = 2;
	memcpy(header+22,&s,2);
	i = 44100;
	memcpy(header+24,&i,4);
	i = 176400;
	memcpy(header+28,&i,4);
	s = 4;
	memcpy(header+32,&s,2);
	s = 16;
	memcpy(header+34,&s,2);
	memcpy(header+36,"data",4);
	i = datasize;
	memcpy(header+40,&i,4);

}

int main(int argc,char *argv[]){
	FILE *datf,*bgmf;
	int i,j,l,k;
	int rep=2;
	int length;
	int fade=0;
	int fadep=0;
	int ts=0;
	int te=MAX_BGM;
	char header[44];
	short buf[44100*2];
	int s,e;
	double d;


	//bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	//ꂼʒuɊZ
	for(i=0;i<MAX_BGM;i++){
		bgmtable[i][1]+=bgmtable[i][0];
		bgmtable[i][2]+=bgmtable[i][0];
	}

	//argc̃`FbN
	for(i=1;i<argc;i++){
		switch(argv[i][0]){
		case 'f' :
			argv[i]++; fade=atoi(argv[i]); break;
		case 'F' :
			argv[i]++; fade=-atoi(argv[i]); break;
		case 'P' :
		case 'p' :
			argv[i]++; fadep=atoi(argv[i]); break;
		case 'T' :
		case 't' :
			argv[i]++; ts=te=atoi(argv[i]); break;
		default:
			rep=atoi(argv[i]);
		}
	}

	if(rep<1 || rep>10){
		printf("repeat must be 1-10\n");
		return 0;
	}
	if(fade<-30 || fade>30){
		printf("fade must be 0-30\n");
		return 0;
	}
	if(fadep<0 || fadep>3){
		printf("fade pattern must be 0-3\n");
		return 0;
	}
	if(ts<0 || te>MAX_BGM){
		printf("track number must be 1-%d\n", MAX_BGM);
		return 0;
	}


	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n",ts+1,te,rep,fade,fadep);
	if(ts) ts--;

	datf=fopen(BGM_FILE,"rb");
	if(datf==NULL){
		printf("%s not found.", BGM_FILE);
		return 0;
	}

	//Jn
	for(i=ts;i<te;i++){

		printf("Create %s ...\n",bgmfile[i]);
		bgmf=fopen(bgmfile[i],"wb");
		length=(bgmtable[i][2]-bgmtable[i][0])+(bgmtable[i][2]-bgmtable[i][1])*(rep-1);
		if(fade<0) length+=(-fade)*44100*4;
		makeheader(header,length);
		fwrite(header,1,44,bgmf);

		//[v
		for(k=0;k<rep;k++){
			//[
			s=bgmtable[i][1];
			if(k==0) s=bgmtable[i][0];

			//I[
			e=bgmtable[i][2];
			if(k==rep-1 && fade>0) e=bgmtable[i][2]-fade*44100*4;

			for(j=s;j<e;j+=44100*4){
				if(j+44100*4>e) l=e-j;
				else l=44100*4;

				fseek(datf,j,SEEK_SET);
				fread(buf,1,l,datf);
				fwrite(buf,1,l,bgmf);
			}
		}

		//tF[hAEg
		if(fade>0){
			//[vI[
			s=bgmtable[i][2]-fade*44100*4;
			e=bgmtable[i][2];
		}
		else if(fade<0){
			//[v[
			s=bgmtable[i][1];
			e=s-fade*44100*4;
		}
		else{
			s=e=0;
		}

		for(j=s;j<e;j+=44100*4){
			if(j+44100*4>e) l=e-j;
			else l=44100*4;

			fseek(datf,j,SEEK_SET);
			fread(buf,1,l,datf);
			for(k=0;k<l/4;k++){
				switch (fadep) {
				case 0 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=pow(0.001,d);
					break;
				case 1 :
					d=1-(float)((j-s)/4+k)/(abs(fade)*44100);
					break;
				case 2 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=(pow(0.001,d)+(1-d))/2;
					break;
				case 3 :
					d=(cos(3.1415926535*(float)((j-s)/4+k)/(abs(fade)*44100))+1)/2;
					break;
				}

				buf[2*k]=(short)(buf[2*k]*d);
				buf[2*k+1]=(short)(buf[2*k+1]*d);
			}
			fwrite(buf,1,l,bgmf);
		}

		fclose(bgmf);
	}
	fclose(datf);

	return 0;
}
